#include "Simulator.h"

Simulator::Simulator(Circuit *c, QObject *parent) :
    QObject(parent)
{
    this->circuit = c;
}

void Simulator::singleStep()
{
    // Iterate through and simulate gates in the queue
    currQueue = nextQueue;
    nextQueue.clear();
    while (!currQueue.isEmpty()) {
        Gate_BASE *g = currQueue.first();
        g->simulateToOutput();
        g->setEnqueued(false);
        currQueue.removeFirst();
    }
}

void Simulator::autoStep()
{
    // Continuously simulate until no more gates are queued
    currQueue = nextQueue;
    nextQueue.clear();
    do {
        while (!currQueue.isEmpty()) {
            Gate_BASE *g = currQueue.first();
            g->simulateToOutput();
            g->setEnqueued(false);
            currQueue.removeFirst();
        }
        currQueue = nextQueue;
        nextQueue.clear();
    } while (!currQueue.isEmpty());
}

void Simulator::enqueueGate(Gate_BASE *gate)
{
    gate->setEnqueued(true);
    nextQueue.enqueue(gate);
}
